/*
 * Copyright (c) 2000, 2019, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.security.tools.jarsigner;

/**
 * <p> This class represents the <code>ResourceBundle</code>
 * for JarSigner.
 *
 */
public class Resources_ja extends java.util.ListResourceBundle {

    private static final Object[][] contents = {

        // shared (from jarsigner)
        {"SPACE", " "},
        {"2SPACE", "  "},
        {"6SPACE", "      "},
        {"COMMA", ", "},

        {"provclass.not.a.provider", "%s\u306F\u30D7\u30ED\u30D0\u30A4\u30C0\u3067\u306F\u3042\u308A\u307E\u305B\u3093"},
        {"provider.name.not.found", "\u30D7\u30ED\u30D0\u30A4\u30C0\u540D\"%s\"\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093"},
        {"provider.class.not.found", "\u30D7\u30ED\u30D0\u30A4\u30C0\"%s\"\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093"},
        {"jarsigner.error.", "jarsigner\u30A8\u30E9\u30FC: "},
        {"Illegal.option.", "\u4E0D\u6B63\u306A\u30AA\u30D7\u30B7\u30E7\u30F3: "},
        {"This.option.is.deprecated", "\u3053\u306E\u30AA\u30D7\u30B7\u30E7\u30F3\u306F\u975E\u63A8\u5968\u3067\u3059: "},
        {".keystore.must.be.NONE.if.storetype.is.{0}",
                "-storetype\u304C{0}\u306E\u5834\u5408\u3001-keystore\u306FNONE\u3067\u3042\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059"},
        {".keypass.can.not.be.specified.if.storetype.is.{0}",
                "-storetype\u304C{0}\u306E\u5834\u5408\u3001-keypass\u306F\u6307\u5B9A\u3067\u304D\u307E\u305B\u3093"},
        {"If.protected.is.specified.then.storepass.and.keypass.must.not.be.specified",
                "-protected\u3092\u6307\u5B9A\u3059\u308B\u5834\u5408\u306F\u3001-storepass\u304A\u3088\u3073-keypass\u3092\u6307\u5B9A\u3057\u306A\u3044\u3067\u304F\u3060\u3055\u3044"},
        {"If.keystore.is.not.password.protected.then.storepass.and.keypass.must.not.be.specified",
                 "\u30AD\u30FC\u30B9\u30C8\u30A2\u304C\u30D1\u30B9\u30EF\u30FC\u30C9\u3067\u4FDD\u8B77\u3055\u308C\u3066\u3044\u306A\u3044\u5834\u5408\u3001-storepass\u304A\u3088\u3073-keypass\u3092\u6307\u5B9A\u3057\u306A\u3044\u3067\u304F\u3060\u3055\u3044"},
        {"Usage.jarsigner.options.jar.file.alias",
                "\u4F7F\u7528\u65B9\u6CD5: jarsigner [options] jar-file alias"},
        {".jarsigner.verify.options.jar.file.alias.",
                "       jarsigner -verify [options] jar-file [alias...]"},
        {".keystore.url.keystore.location",
                "[-keystore <url>]           \u30AD\u30FC\u30B9\u30C8\u30A2\u306E\u4F4D\u7F6E"},
        {".storepass.password.password.for.keystore.integrity",
            "[-storepass <password>]     \u30AD\u30FC\u30B9\u30C8\u30A2\u6574\u5408\u6027\u306E\u305F\u3081\u306E\u30D1\u30B9\u30EF\u30FC\u30C9"},
        {".storetype.type.keystore.type",
                "[-storetype <type>]         \u30AD\u30FC\u30B9\u30C8\u30A2\u306E\u578B"},
        {".keypass.password.password.for.private.key.if.different.",
                "[-keypass <password>]       \u79D8\u5BC6\u30AD\u30FC\u306E\u30D1\u30B9\u30EF\u30FC\u30C9(\u7570\u306A\u308B\u5834\u5408)"},
        {".certchain.file.name.of.alternative.certchain.file",
                "[-certchain <file>]         \u4EE3\u66FF\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u30FB\u30D5\u30A1\u30A4\u30EB\u306E\u540D\u524D"},
        {".sigfile.file.name.of.SF.DSA.file",
                "[-sigfile <file>]           .SF/.DSA\u30D5\u30A1\u30A4\u30EB\u306E\u540D\u524D"},
        {".signedjar.file.name.of.signed.JAR.file",
                "[-signedjar <file>]         \u7F72\u540D\u4ED8\u304DJAR\u30D5\u30A1\u30A4\u30EB\u306E\u540D\u524D"},
        {".digestalg.algorithm.name.of.digest.algorithm",
                "[-digestalg <algorithm>]    \u30C0\u30A4\u30B8\u30A7\u30B9\u30C8\u30FB\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0\u306E\u540D\u524D"},
        {".sigalg.algorithm.name.of.signature.algorithm",
                "[-sigalg <algorithm>]       \u30B7\u30B0\u30CD\u30C1\u30E3\u30FB\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0\u306E\u540D\u524D"},
        {".verify.verify.a.signed.JAR.file",
                "[-verify]                   \u7F72\u540D\u4ED8\u304DJAR\u30D5\u30A1\u30A4\u30EB\u306E\u691C\u8A3C"},
        {".verbose.suboptions.verbose.output.when.signing.verifying.",
                "[-verbose[:suboptions]]     \u7F72\u540D/\u691C\u8A3C\u6642\u306E\u8A73\u7D30\u51FA\u529B\u3002"},
        {".suboptions.can.be.all.grouped.or.summary",
                "                            \u30B5\u30D6\u30AA\u30D7\u30B7\u30E7\u30F3\u3068\u3057\u3066\u3001all\u3001grouped\u307E\u305F\u306Fsummary\u3092\u4F7F\u7528\u3067\u304D\u307E\u3059"},
        {".certs.display.certificates.when.verbose.and.verifying",
                "[-certs]                    \u8A73\u7D30\u51FA\u529B\u304A\u3088\u3073\u691C\u8A3C\u6642\u306B\u8A3C\u660E\u66F8\u3092\u8868\u793A"},
        {".tsa.url.location.of.the.Timestamping.Authority",
                "[-tsa <url>]                \u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u5C40\u306E\u5834\u6240"},
        {".tsacert.alias.public.key.certificate.for.Timestamping.Authority",
                "[-tsacert <alias>]          \u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u5C40\u306E\u516C\u958B\u30AD\u30FC\u8A3C\u660E\u66F8"},
        {".tsapolicyid.tsapolicyid.for.Timestamping.Authority",
                "[-tsapolicyid <oid>]        \u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u5C40\u306ETSAPolicyID"},
        {".tsadigestalg.algorithm.of.digest.data.in.timestamping.request",
                "[-tsadigestalg <algorithm>] \u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u30FB\u30EA\u30AF\u30A8\u30B9\u30C8\u306E\u30C0\u30A4\u30B8\u30A7\u30B9\u30C8\u30FB\u30C7\u30FC\u30BF\u306E\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0"},
        {".altsigner.class.class.name.of.an.alternative.signing.mechanism",
                "[-altsigner <class>]        \u4EE3\u66FF\u7F72\u540D\u30E1\u30AB\u30CB\u30BA\u30E0\u306E\u30AF\u30E9\u30B9\u540D\n                            (\u3053\u306E\u30AA\u30D7\u30B7\u30E7\u30F3\u306F\u975E\u63A8\u5968\u306B\u306A\u308A\u307E\u3057\u305F\u3002)"},
        {".altsignerpath.pathlist.location.of.an.alternative.signing.mechanism",
                "[-altsignerpath <pathlist>] \u4EE3\u66FF\u7F72\u540D\u30E1\u30AB\u30CB\u30BA\u30E0\u306E\u5834\u6240\n                            (\u3053\u306E\u30AA\u30D7\u30B7\u30E7\u30F3\u306F\u975E\u63A8\u5968\u306B\u306A\u308A\u307E\u3057\u305F\u3002)"},
        {".internalsf.include.the.SF.file.inside.the.signature.block",
                "[-internalsf]               \u30B7\u30B0\u30CD\u30C1\u30E3\u30FB\u30D6\u30ED\u30C3\u30AF\u306B.SF\u30D5\u30A1\u30A4\u30EB\u3092\u542B\u3081\u308B"},
        {".sectionsonly.don.t.compute.hash.of.entire.manifest",
                "[-sectionsonly]             \u30DE\u30CB\u30D5\u30A7\u30B9\u30C8\u5168\u4F53\u306E\u30CF\u30C3\u30B7\u30E5\u306F\u8A08\u7B97\u3057\u306A\u3044"},
        {".protected.keystore.has.protected.authentication.path",
                "[-protected]                \u30AD\u30FC\u30B9\u30C8\u30A2\u306B\u306F\u4FDD\u8B77\u3055\u308C\u305F\u8A8D\u8A3C\u30D1\u30B9\u304C\u3042\u308B"},
        {".providerName.name.provider.name",
                "[-providerName <name>]      \u30D7\u30ED\u30D0\u30A4\u30C0\u540D"},
        {".add.provider.option",
                "[-addprovider <name>        \u540D\u524D\u3067\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u30FB\u30D7\u30ED\u30D0\u30A4\u30C0\u3092\u8FFD\u52A0\u3059\u308B(SunPKCS11\u306A\u3069)"},
        {".providerArg.option.1",
                "  [-providerArg <arg>]] ... -addprovider\u306E\u5F15\u6570\u3092\u69CB\u6210\u3059\u308B"},
        {".providerClass.option",
                "[-providerClass <class>     \u5B8C\u5168\u4FEE\u98FE\u30AF\u30E9\u30B9\u540D\u3067\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u30FB\u30D7\u30ED\u30D0\u30A4\u30C0\u3092\u8FFD\u52A0\u3059\u308B"},
        {".providerArg.option.2",
                "  [-providerArg <arg>]] ... -providerClass\u306E\u5F15\u6570\u3092\u69CB\u6210\u3059\u308B"},
        {".strict.treat.warnings.as.errors",
                "[-strict]                   \u8B66\u544A\u3092\u30A8\u30E9\u30FC\u3068\u3057\u3066\u51E6\u7406"},
        {".conf.url.specify.a.pre.configured.options.file",
                "[-conf <url>]               \u4E8B\u524D\u69CB\u6210\u6E08\u306E\u30AA\u30D7\u30B7\u30E7\u30F3\u30FB\u30D5\u30A1\u30A4\u30EB\u3092\u6307\u5B9A\u3059\u308B"},
        {".print.this.help.message",
                "[-? -h --help]              \u3053\u306E\u30D8\u30EB\u30D7\u30FB\u30E1\u30C3\u30BB\u30FC\u30B8\u3092\u51FA\u529B\u3057\u307E\u3059"},
        {"Option.lacks.argument", "\u30AA\u30D7\u30B7\u30E7\u30F3\u306B\u5F15\u6570\u304C\u3042\u308A\u307E\u305B\u3093"},
        {"Please.type.jarsigner.help.for.usage", "\u4F7F\u7528\u65B9\u6CD5\u306B\u3064\u3044\u3066\u306Fjarsigner --help\u3068\u5165\u529B\u3057\u3066\u304F\u3060\u3055\u3044"},
        {"Please.specify.jarfile.name", "jarfile\u540D\u3092\u6307\u5B9A\u3057\u3066\u304F\u3060\u3055\u3044"},
        {"Please.specify.alias.name", "\u5225\u540D\u3092\u6307\u5B9A\u3057\u3066\u304F\u3060\u3055\u3044"},
        {"Only.one.alias.can.be.specified", "\u5225\u540D\u306F1\u3064\u306E\u307F\u6307\u5B9A\u3067\u304D\u307E\u3059"},
        {"This.jar.contains.signed.entries.which.is.not.signed.by.the.specified.alias.es.",
                 "\u3053\u306Ejar\u306B\u542B\u307E\u308C\u308B\u7F72\u540D\u6E08\u30A8\u30F3\u30C8\u30EA\u306F\u3001\u6307\u5B9A\u3055\u308C\u305F\u5225\u540D\u306B\u3088\u3063\u3066\u7F72\u540D\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002"},
        {"This.jar.contains.signed.entries.that.s.not.signed.by.alias.in.this.keystore.",
                  "\u3053\u306Ejar\u306B\u542B\u307E\u308C\u308B\u7F72\u540D\u6E08\u30A8\u30F3\u30C8\u30EA\u306F\u3001\u3053\u306E\u30AD\u30FC\u30B9\u30C8\u30A2\u5185\u306E\u5225\u540D\u306B\u3088\u3063\u3066\u7F72\u540D\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002"},
        {"s", "s"},
        {"m", "m"},
        {"k", "k"},
        {".and.d.more.", "(\u4ED6\u306B\u3082%d\u500B)"},
        {".s.signature.was.verified.",
                "  s=\u30B7\u30B0\u30CD\u30C1\u30E3\u304C\u691C\u8A3C\u3055\u308C\u307E\u3057\u305F "},
        {".m.entry.is.listed.in.manifest",
                "  m=\u30A8\u30F3\u30C8\u30EA\u304C\u30DE\u30CB\u30D5\u30A7\u30B9\u30C8\u5185\u306B\u30EA\u30B9\u30C8\u3055\u308C\u307E\u3059"},
        {".k.at.least.one.certificate.was.found.in.keystore",
                "  k=1\u3064\u4EE5\u4E0A\u306E\u8A3C\u660E\u66F8\u304C\u30AD\u30FC\u30B9\u30C8\u30A2\u3067\u691C\u51FA\u3055\u308C\u307E\u3057\u305F"},
        {".X.not.signed.by.specified.alias.es.",
                "  X =\u6307\u5B9A\u3057\u305F\u5225\u540D\u3067\u7F72\u540D\u3055\u308C\u3066\u3044\u307E\u305B\u3093"},
        {"no.manifest.", "\u30DE\u30CB\u30D5\u30A7\u30B9\u30C8\u306F\u5B58\u5728\u3057\u307E\u305B\u3093\u3002"},
        {".Signature.related.entries.","(\u30B7\u30B0\u30CD\u30C1\u30E3\u95A2\u9023\u30A8\u30F3\u30C8\u30EA)"},
        {".Unsigned.entries.", "(\u7F72\u540D\u306A\u3057\u306E\u30A8\u30F3\u30C8\u30EA)"},
        {"jar.is.unsigned",
                "jar\u306F\u7F72\u540D\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002"},
        {"jar.treated.unsigned",
                "\u8B66\u544A: \u7F72\u540D\u304C\u69CB\u6587\u89E3\u6790\u3067\u304D\u306A\u3044\u304B\u691C\u8A3C\u3067\u304D\u306A\u3044\u305F\u3081\u3001\u3053\u306Ejar\u306F\u7F72\u540D\u306A\u3057\u3068\u3057\u3066\u6271\u308F\u308C\u307E\u3059\u3002\u8A73\u7D30\u306F\u3001\u30C7\u30D0\u30C3\u30B0\u3092\u6709\u52B9\u306B\u3057\u3066(-J-Djava.security.debug=jar) jarsigner\u3092\u518D\u5B9F\u884C\u3057\u3066\u304F\u3060\u3055\u3044\u3002"},
        {"jar.treated.unsigned.see.weak",
                "\u3053\u306Ejar\u306F\u3001\u73FE\u5728\u7121\u52B9\u306B\u306A\u3063\u3066\u3044\u308B\u5F31\u3044\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0\u3067\u7F72\u540D\u3055\u308C\u3066\u3044\u308B\u305F\u3081\u3001\u7F72\u540D\u306A\u3057\u3068\u3057\u3066\u6271\u308F\u308C\u307E\u3059\u3002\n\n\u8A73\u7D30\u306F\u3001-verbose\u30AA\u30D7\u30B7\u30E7\u30F3\u3092\u4F7F\u7528\u3057\u3066jarsigner\u3092\u518D\u5B9F\u884C\u3057\u3066\u304F\u3060\u3055\u3044\u3002"},
        {"jar.treated.unsigned.see.weak.verbose",
                "\u8B66\u544A: \u3053\u306Ejar\u306F\u3001\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u30FB\u30D7\u30ED\u30D1\u30C6\u30A3\u306B\u3088\u3063\u3066\u73FE\u5728\u7121\u52B9\u306B\u306A\u3063\u3066\u3044\u308B\u5F31\u3044\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0\u3067\u7F72\u540D\u3055\u308C\u3066\u3044\u308B\u305F\u3081\u3001\u7F72\u540D\u306A\u3057\u3068\u3057\u3066\u6271\u308F\u308C\u307E\u3059:"},
        {"jar.signed.", "jar\u306F\u7F72\u540D\u3055\u308C\u307E\u3057\u305F\u3002"},
        {"jar.signed.with.signer.errors.", "jar\u306F\u7F72\u540D\u3055\u308C\u307E\u3057\u305F - \u7F72\u540D\u8005\u30A8\u30E9\u30FC\u304C\u3042\u308A\u307E\u3059\u3002"},
        {"jar.verified.", "jar\u304C\u691C\u8A3C\u3055\u308C\u307E\u3057\u305F\u3002"},
        {"jar.verified.with.signer.errors.", "jar\u306F\u691C\u8A3C\u3055\u308C\u307E\u3057\u305F - \u7F72\u540D\u8005\u30A8\u30E9\u30FC\u304C\u3042\u308A\u307E\u3059\u3002"},

        {"history.with.ts", "- \u7F72\u540D\u8005: \"%1$s\"\n    \u30C0\u30A4\u30B8\u30A7\u30B9\u30C8\u30FB\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0: %2$s\n    \u7F72\u540D\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0: %3$s\u3001%4$s\n  \u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u4ED8\u52A0\u8005: \"%6$s\" \u65E5\u6642: %5$tc\n    \u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306E\u30C0\u30A4\u30B8\u30A7\u30B9\u30C8\u30FB\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0: %7$s\n    \u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306E\u7F72\u540D\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0: %8$s\u3001%9$s"},
        {"history.without.ts", "- \u7F72\u540D\u8005: \"%1$s\"\n    \u30C0\u30A4\u30B8\u30A7\u30B9\u30C8\u30FB\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0: %2$s\n    \u7F72\u540D\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0: %3$s\u3001%4$s"},
        {"history.unparsable", "- \u7F72\u540D\u95A2\u9023\u30D5\u30A1\u30A4\u30EB%s\u3092\u89E3\u6790\u3067\u304D\u307E\u305B\u3093"},
        {"history.nosf", "- \u7F72\u540D\u95A2\u9023\u30D5\u30A1\u30A4\u30EBMETA-INF/%s.SF\u304C\u3042\u308A\u307E\u305B\u3093"},
        {"history.nobk", "- \u7F72\u540D\u95A2\u9023\u30D5\u30A1\u30A4\u30EBMETA-INF/%s.SF\u306E\u30D6\u30ED\u30C3\u30AF\u30FB\u30D5\u30A1\u30A4\u30EB\u304C\u3042\u308A\u307E\u305B\u3093"},

        {"with.weak", "%s (\u5F31)"},
        {"key.bit", "%d\u30D3\u30C3\u30C8\u30FB\u30AD\u30FC"},
        {"key.bit.weak", "%d\u30D3\u30C3\u30C8\u30FB\u30AD\u30FC(\u5F31)"},
        {"unknown.size", "\u4E0D\u660E\u30B5\u30A4\u30BA"},

        {"jarsigner.", "jarsigner: "},
        {"signature.filename.must.consist.of.the.following.characters.A.Z.0.9.or.",
                "\u30B7\u30B0\u30CD\u30C1\u30E3\u306E\u30D5\u30A1\u30A4\u30EB\u540D\u306B\u4F7F\u7528\u3067\u304D\u308B\u6587\u5B57\u306F\u3001A-Z\u30010-9\u3001_\u3001- \u306E\u307F\u3067\u3059\u3002"},
        {"unable.to.open.jar.file.", "\u6B21\u306Ejar\u30D5\u30A1\u30A4\u30EB\u3092\u958B\u304F\u3053\u3068\u304C\u3067\u304D\u307E\u305B\u3093: "},
        {"unable.to.create.", "\u4F5C\u6210\u3067\u304D\u307E\u305B\u3093: "},
        {".adding.", "   \u8FFD\u52A0\u4E2D: "},
        {".updating.", " \u66F4\u65B0\u4E2D: "},
        {".signing.", "  \u7F72\u540D\u4E2D: "},
        {"attempt.to.rename.signedJarFile.to.jarFile.failed",
                "{0}\u306E\u540D\u524D\u3092{1}\u306B\u5909\u66F4\u3057\u3088\u3046\u3068\u3057\u307E\u3057\u305F\u304C\u5931\u6557\u3057\u307E\u3057\u305F"},
        {"attempt.to.rename.jarFile.to.origJar.failed",
                "{0}\u306E\u540D\u524D\u3092{1}\u306B\u5909\u66F4\u3057\u3088\u3046\u3068\u3057\u307E\u3057\u305F\u304C\u5931\u6557\u3057\u307E\u3057\u305F"},
        {"unable.to.sign.jar.", "jar\u306B\u7F72\u540D\u3067\u304D\u307E\u305B\u3093: "},
        {"Enter.Passphrase.for.keystore.", "\u30AD\u30FC\u30B9\u30C8\u30A2\u306E\u30D1\u30B9\u30EF\u30FC\u30C9\u3092\u5165\u529B\u3057\u3066\u304F\u3060\u3055\u3044: "},
        {"keystore.load.", "\u30AD\u30FC\u30B9\u30C8\u30A2\u306E\u30ED\u30FC\u30C9: "},
        {"certificate.exception.", "\u8A3C\u660E\u66F8\u4F8B\u5916: "},
        {"unable.to.instantiate.keystore.class.",
                "\u30AD\u30FC\u30B9\u30C8\u30A2\u30FB\u30AF\u30E9\u30B9\u306E\u30A4\u30F3\u30B9\u30BF\u30F3\u30B9\u3092\u751F\u6210\u3067\u304D\u307E\u305B\u3093: "},
        {"Certificate.chain.not.found.for.alias.alias.must.reference.a.valid.KeyStore.key.entry.containing.a.private.key.and",
                "\u6B21\u306E\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093: {0}\u3002{1}\u306F\u3001\u79D8\u5BC6\u30AD\u30FC\u304A\u3088\u3073\u5BFE\u5FDC\u3059\u308B\u516C\u958B\u30AD\u30FC\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u3092\u542B\u3080\u6709\u52B9\u306AKeyStore\u30AD\u30FC\u30FB\u30A8\u30F3\u30C8\u30EA\u3092\u53C2\u7167\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059\u3002"},
        {"File.specified.by.certchain.does.not.exist",
                "-certchain\u3067\u6307\u5B9A\u3055\u308C\u3066\u3044\u308B\u30D5\u30A1\u30A4\u30EB\u306F\u5B58\u5728\u3057\u307E\u305B\u3093"},
        {"Cannot.restore.certchain.from.file.specified",
                "\u6307\u5B9A\u3055\u308C\u305F\u30D5\u30A1\u30A4\u30EB\u304B\u3089\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u3092\u5FA9\u5143\u3067\u304D\u307E\u305B\u3093"},
        {"Certificate.chain.not.found.in.the.file.specified.",
                "\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u306F\u6307\u5B9A\u3055\u308C\u305F\u30D5\u30A1\u30A4\u30EB\u306B\u898B\u3064\u304B\u308A\u307E\u305B\u3093\u3002"},
        {"found.non.X.509.certificate.in.signer.s.chain",
                "\u7F72\u540D\u8005\u306E\u9023\u9396\u5185\u3067\u975EX.509\u8A3C\u660E\u66F8\u304C\u691C\u51FA\u3055\u308C\u307E\u3057\u305F"},
        {"incomplete.certificate.chain", "\u4E0D\u5B8C\u5168\u306A\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3"},
        {"Enter.key.password.for.alias.", "{0}\u306E\u30AD\u30FC\u30FB\u30D1\u30B9\u30EF\u30FC\u30C9\u3092\u5165\u529B\u3057\u3066\u304F\u3060\u3055\u3044: "},
        {"unable.to.recover.key.from.keystore",
                "\u30AD\u30FC\u30B9\u30C8\u30A2\u304B\u3089\u30AD\u30FC\u3092\u5FA9\u5143\u3067\u304D\u307E\u305B\u3093"},
        {"key.associated.with.alias.not.a.private.key",
                "{0}\u3068\u95A2\u9023\u4ED8\u3051\u3089\u308C\u305F\u30AD\u30FC\u306F\u3001\u79D8\u5BC6\u30AD\u30FC\u3067\u306F\u3042\u308A\u307E\u305B\u3093"},
        {"you.must.enter.key.password", "\u30AD\u30FC\u30FB\u30D1\u30B9\u30EF\u30FC\u30C9\u3092\u5165\u529B\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059"},
        {"unable.to.read.password.", "\u30D1\u30B9\u30EF\u30FC\u30C9\u3092\u8AAD\u307F\u8FBC\u3081\u307E\u305B\u3093: "},
        {"certificate.is.valid.from", "\u8A3C\u660E\u66F8\u306F{0}\u304B\u3089{1}\u307E\u3067\u6709\u52B9\u3067\u3059"},
        {"certificate.expired.on", "\u8A3C\u660E\u66F8\u306F{0}\u306B\u5931\u52B9\u3057\u307E\u3057\u305F"},
        {"certificate.is.not.valid.until",
                "\u8A3C\u660E\u66F8\u306F{0}\u307E\u3067\u6709\u52B9\u3067\u306F\u3042\u308A\u307E\u305B\u3093"},
        {"certificate.will.expire.on", "\u8A3C\u660E\u66F8\u306F{0}\u306B\u5931\u52B9\u3057\u307E\u3059"},
        {".Invalid.certificate.chain.", "[\u7121\u52B9\u306A\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3: "},
        {".Invalid.TSA.certificate.chain.", "[\u7121\u52B9\u306ATSA\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3: "},
        {"requesting.a.signature.timestamp",
                "\u30B7\u30B0\u30CD\u30C1\u30E3\u30FB\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306E\u30EA\u30AF\u30A8\u30B9\u30C8"},
        {"TSA.location.", "TSA\u306E\u5834\u6240: "},
        {"TSA.certificate.", "TSA\u8A3C\u660E\u66F8: "},
        {"no.response.from.the.Timestamping.Authority.",
                "\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u5C40\u304B\u3089\u306E\u30EC\u30B9\u30DD\u30F3\u30B9\u304C\u3042\u308A\u307E\u305B\u3093\u3002\u30D5\u30A1\u30A4\u30A2\u30A6\u30A9\u30FC\u30EB\u3092\u4ECB\u3057\u3066\u63A5\u7D9A\u3059\u308B\u3068\u304D\u306F\u3001\u5FC5\u8981\u306B\u5FDC\u3058\u3066HTTP\u307E\u305F\u306FHTTPS\u30D7\u30ED\u30AD\u30B7\u3092\u6307\u5B9A\u3057\u3066\u304F\u3060\u3055\u3044\u3002jarsigner\u306B\u6B21\u306E\u30AA\u30D7\u30B7\u30E7\u30F3\u3092\u6307\u5B9A\u3057\u3066\u304F\u3060\u3055\u3044:"},
        {"or", "\u307E\u305F\u306F"},
        {"Certificate.not.found.for.alias.alias.must.reference.a.valid.KeyStore.entry.containing.an.X.509.public.key.certificate.for.the",
                "\u8A3C\u660E\u66F8\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093\u3067\u3057\u305F: {0}\u3002{1}\u306F\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u5C40\u306EX.509\u516C\u958B\u30AD\u30FC\u8A3C\u660E\u66F8\u304C\u542B\u307E\u308C\u3066\u3044\u308B\u6709\u52B9\u306AKeyStore\u30A8\u30F3\u30C8\u30EA\u3092\u53C2\u7167\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059\u3002"},
        {"using.an.alternative.signing.mechanism",
                "\u4EE3\u66FF\u7F72\u540D\u30E1\u30AB\u30CB\u30BA\u30E0\u306E\u4F7F\u7528"},
        {"entry.was.signed.on", "\u30A8\u30F3\u30C8\u30EA\u306F{0}\u306B\u7F72\u540D\u3055\u308C\u307E\u3057\u305F"},
        {"Warning.", "\u8B66\u544A: "},
        {"Error.", "\u30A8\u30E9\u30FC: "},
        {"...Signer", ">>> \u7F72\u540D\u8005"},
        {"...TSA", ">>> TSA"},
        {"trusted.certificate", "\u4FE1\u983C\u3067\u304D\u308B\u8A3C\u660E\u66F8"},
        {"This.jar.contains.unsigned.entries.which.have.not.been.integrity.checked.",
                "\u3053\u306Ejar\u306B\u306F\u3001\u6574\u5408\u6027\u30C1\u30A7\u30C3\u30AF\u3092\u3057\u3066\u3044\u306A\u3044\u7F72\u540D\u306A\u3057\u306E\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002 "},
        {"This.jar.contains.entries.whose.signer.certificate.has.expired.",
                "\u3053\u306Ejar\u306B\u306F\u3001\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u304C\u671F\u9650\u5207\u308C\u306E\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002 "},
        {"This.jar.contains.entries.whose.signer.certificate.will.expire.within.six.months.",
                "\u3053\u306Ejar\u306B\u306F\u3001\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u304C6\u304B\u6708\u4EE5\u5185\u306B\u671F\u9650\u5207\u308C\u3068\u306A\u308B\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002 "},
        {"This.jar.contains.entries.whose.signer.certificate.is.not.yet.valid.",
                "\u3053\u306Ejar\u306B\u306F\u3001\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u304C\u307E\u3060\u6709\u52B9\u306B\u306A\u3063\u3066\u3044\u306A\u3044\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002 "},
        {"This.jar.contains.entries.whose.signer.certificate.is.self.signed.",
                "\u3053\u306Ejar\u306B\u306F\u3001\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u304C\u81EA\u5DF1\u7F72\u540D\u3055\u308C\u3066\u3044\u308B\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002 "},
        {"Re.run.with.the.verbose.option.for.more.details.",
                "\u8A73\u7D30\u306F\u3001-verbose\u30AA\u30D7\u30B7\u30E7\u30F3\u3092\u4F7F\u7528\u3057\u3066\u518D\u5B9F\u884C\u3057\u3066\u304F\u3060\u3055\u3044\u3002"},
        {"Re.run.with.the.verbose.and.certs.options.for.more.details.",
                "\u8A73\u7D30\u306F\u3001-verbose\u304A\u3088\u3073-certs\u30AA\u30D7\u30B7\u30E7\u30F3\u3092\u4F7F\u7528\u3057\u3066\u518D\u5B9F\u884C\u3057\u3066\u304F\u3060\u3055\u3044\u3002"},
        {"The.signer.certificate.has.expired.",
                "\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u306F\u671F\u9650\u5207\u308C\u3067\u3059\u3002"},
        {"The.timestamp.expired.1.but.usable.2",
                "\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306F%1$tY-%1$tm-%1$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308A\u307E\u3059\u3002\u305F\u3060\u3057\u3001JAR\u306F\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u304C%2$tY-%2$tm-%2$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308B\u307E\u3067\u6709\u52B9\u3067\u3059\u3002"},
        {"The.timestamp.has.expired.",
                "\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306F\u671F\u9650\u5207\u308C\u306B\u306A\u308A\u307E\u3057\u305F\u3002"},
        {"The.signer.certificate.will.expire.within.six.months.",
                "\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u306F6\u304B\u6708\u4EE5\u5185\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308A\u307E\u3059\u3002"},
        {"The.timestamp.will.expire.within.one.year.on.1",
                "\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306F1\u5E74\u4EE5\u5185\u306E%1$tY-%1$tm-%1$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308A\u307E\u3059\u3002"},
        {"The.timestamp.will.expire.within.one.year.on.1.but.2",
                "\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306F1\u5E74\u4EE5\u5185\u306E%1$tY-%1$tm-%1$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308A\u307E\u3059\u3002\u305F\u3060\u3057\u3001JAR\u306F\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u304C%2$tY-%2$tm-%2$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308B\u307E\u3067\u6709\u52B9\u3067\u3059\u3002"},
        {"The.signer.certificate.is.not.yet.valid.",
                "\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u306F\u307E\u3060\u6709\u52B9\u306B\u306A\u3063\u3066\u3044\u307E\u305B\u3093\u3002"},
        {"The.signer.certificate.s.KeyUsage.extension.doesn.t.allow.code.signing.",
                 "\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306EKeyUsage\u62E1\u5F35\u6A5F\u80FD\u3067\u306F\u3001\u30B3\u30FC\u30C9\u7F72\u540D\u306F\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093\u3002"},
        {"The.signer.certificate.s.ExtendedKeyUsage.extension.doesn.t.allow.code.signing.",
                 "\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306EExtendedKeyUsage\u62E1\u5F35\u6A5F\u80FD\u3067\u306F\u3001\u30B3\u30FC\u30C9\u7F72\u540D\u306F\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093\u3002"},
        {"The.signer.certificate.s.NetscapeCertType.extension.doesn.t.allow.code.signing.",
                 "\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306ENetscapeCertType\u62E1\u5F35\u6A5F\u80FD\u3067\u306F\u3001\u30B3\u30FC\u30C9\u7F72\u540D\u306F\u8A31\u53EF\u3055\u308C\u307E\u305B\u3093\u3002"},
        {"This.jar.contains.entries.whose.signer.certificate.s.KeyUsage.extension.doesn.t.allow.code.signing.",
                 "\u3053\u306Ejar\u306B\u306F\u3001\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306EKeyUsage\u62E1\u5F35\u6A5F\u80FD\u304C\u30B3\u30FC\u30C9\u7F72\u540D\u3092\u8A31\u53EF\u3057\u306A\u3044\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002"},
        {"This.jar.contains.entries.whose.signer.certificate.s.ExtendedKeyUsage.extension.doesn.t.allow.code.signing.",
                 "\u3053\u306Ejar\u306B\u306F\u3001\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306EExtendedKeyUsage\u62E1\u5F35\u6A5F\u80FD\u304C\u30B3\u30FC\u30C9\u7F72\u540D\u3092\u8A31\u53EF\u3057\u306A\u3044\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002"},
        {"This.jar.contains.entries.whose.signer.certificate.s.NetscapeCertType.extension.doesn.t.allow.code.signing.",
                 "\u3053\u306Ejar\u306B\u306F\u3001\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306ENetscapeCertType\u62E1\u5F35\u6A5F\u80FD\u304C\u30B3\u30FC\u30C9\u7F72\u540D\u3092\u8A31\u53EF\u3057\u306A\u3044\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002"},
        {".{0}.extension.does.not.support.code.signing.",
                 "[{0}\u62E1\u5F35\u6A5F\u80FD\u306F\u30B3\u30FC\u30C9\u7F72\u540D\u3092\u30B5\u30DD\u30FC\u30C8\u3057\u3066\u3044\u307E\u305B\u3093]"},
        {"The.signer.s.certificate.chain.is.invalid.reason.1",
                "\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u304C\u7121\u52B9\u3067\u3059\u3002\u7406\u7531: %s"},
        {"The.tsa.certificate.chain.is.invalid.reason.1",
                "TSA\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u304C\u7121\u52B9\u3067\u3059\u3002\u7406\u7531: %s"},
        {"The.signer.s.certificate.is.self.signed.",
                "\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u306F\u81EA\u5DF1\u7F72\u540D\u3055\u308C\u3066\u3044\u307E\u3059\u3002"},
        {"The.1.algorithm.specified.for.the.2.option.is.considered.a.security.risk.",
                "%1$s\u30A2\u30EB\u30B4\u30EA\u30BA\u30E0(%2$s\u30AA\u30D7\u30B7\u30E7\u30F3\u306B\u6307\u5B9A)\u306F\u3001\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u30FB\u30EA\u30B9\u30AF\u3068\u307F\u306A\u3055\u308C\u307E\u3059\u3002"},
        {"The.1.signing.key.has.a.keysize.of.2.which.is.considered.a.security.risk.",
                "%1$s\u7F72\u540D\u30AD\u30FC\u306B\u306F\u3001\u30BB\u30AD\u30E5\u30EA\u30C6\u30A3\u30FB\u30EA\u30B9\u30AF\u3068\u307F\u306A\u3055\u308C\u308B%2$d\u306E\u30AD\u30FC\u30FB\u30B5\u30A4\u30BA\u304C\u3042\u308A\u307E\u3059\u3002"},
        {"This.jar.contains.entries.whose.certificate.chain.is.invalid.reason.1",
                 "\u3053\u306Ejar\u306B\u306F\u3001\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u304C\u7121\u52B9\u306A\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002\u7406\u7531: %s"},
        {"This.jar.contains.entries.whose.tsa.certificate.chain.is.invalid.reason.1",
                "\u3053\u306Ejar\u306B\u306F\u3001TSA\u8A3C\u660E\u66F8\u30C1\u30A7\u30FC\u30F3\u304C\u7121\u52B9\u306A\u30A8\u30F3\u30C8\u30EA\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002\u7406\u7531: %s"},
        {"no.timestamp.signing",
                "-tsa\u307E\u305F\u306F-tsacert\u304C\u6307\u5B9A\u3055\u308C\u3066\u3044\u306A\u3044\u305F\u3081\u3001\u3053\u306Ejar\u306B\u306F\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C\u4ED8\u52A0\u3055\u308C\u3066\u3044\u307E\u305B\u3093\u3002\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C\u306A\u3044\u3068\u3001\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306E\u6709\u52B9\u671F\u9650(%1$tY-%1$tm-%1$td)\u5F8C\u306B\u3001\u30E6\u30FC\u30B6\u30FC\u306F\u3053\u306Ejar\u3092\u691C\u8A3C\u3067\u304D\u306A\u3044\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059\u3002"},
        {"invalid.timestamp.signing",
                "\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C\u7121\u52B9\u3067\u3059\u3002\u6709\u52B9\u306A\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C\u306A\u3044\u3068\u3001\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306E\u6709\u52B9\u671F\u9650(%1$tY-%1$tm-%1$td)\u5F8C\u306B\u3001\u30E6\u30FC\u30B6\u30FC\u306F\u3053\u306Ejar\u3092\u691C\u8A3C\u3067\u304D\u306A\u3044\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059\u3002"},
        {"no.timestamp.verifying",
                "\u3053\u306Ejar\u306B\u306F\u3001\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C\u306A\u3044\u7F72\u540D\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C\u306A\u3044\u3068\u3001\u3044\u305A\u308C\u304B\u306E\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306E\u6709\u52B9\u671F\u9650\u5F8C\u306B(\u65E9\u3051\u308C\u3070%1$tY-%1$tm-%1$td)\u30E6\u30FC\u30B6\u30FC\u306F\u3053\u306Ejar\u3092\u691C\u8A3C\u3067\u304D\u306A\u3044\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059\u3002"},
        {"bad.timestamp.verifying",
                "\u3053\u306Ejar\u306B\u306F\u3001\u7121\u52B9\u306A\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306E\u3042\u308B\u7F72\u540D\u304C\u542B\u307E\u308C\u3066\u3044\u307E\u3059\u3002\u6709\u52B9\u306A\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C\u306A\u3044\u3068\u3001\u3044\u305A\u308C\u304B\u306E\u7F72\u540D\u8005\u8A3C\u660E\u66F8\u306E\u6709\u52B9\u671F\u9650\u5F8C\u306B(\u65E9\u3051\u308C\u3070%1$tY-%1$tm-%1$td)\u30E6\u30FC\u30B6\u30FC\u306F\u3053\u306Ejar\u3092\u691C\u8A3C\u3067\u304D\u306A\u3044\u53EF\u80FD\u6027\u304C\u3042\u308A\u307E\u3059\u3002\n\u8A73\u7D30\u306F\u3001-J-Djava.security.debug=jar\u3092\u6307\u5B9A\u3057\u3066jarsigner\u3092\u518D\u5B9F\u884C\u3057\u3066\u304F\u3060\u3055\u3044\u3002"},
        {"The.signer.certificate.will.expire.on.1.",
                "\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u306F%1$tY-%1$tm-%1$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308A\u307E\u3059\u3002"},
        {"The.timestamp.will.expire.on.1.",
                "\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u306F%1$tY-%1$tm-%1$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308A\u307E\u3059\u3002"},
        {"signer.cert.expired.1.but.timestamp.good.2.",
                "\u7F72\u540D\u8005\u306E\u8A3C\u660E\u66F8\u306F%1$tY-%1$tm-%1$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308A\u307E\u3059\u3002\u305F\u3060\u3057\u3001JAR\u306F\u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C%2$tY-%2$tm-%2$td\u306B\u671F\u9650\u5207\u308C\u306B\u306A\u308B\u307E\u3067\u6709\u52B9\u3067\u3059\u3002"},
        {"Unknown.password.type.", "\u4E0D\u660E\u306A\u30D1\u30B9\u30EF\u30FC\u30C9\u30FB\u30BF\u30A4\u30D7: "},
        {"Cannot.find.environment.variable.",
                "\u74B0\u5883\u5909\u6570\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093: "},
        {"Cannot.find.file.", "\u30D5\u30A1\u30A4\u30EB\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093: "},
    };

    /**
     * Returns the contents of this <code>ResourceBundle</code>.
     *
     * <p>
     *
     * @return the contents of this <code>ResourceBundle</code>.
     */
    @Override
    public Object[][] getContents() {
        return contents;
    }
}
