/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/*
 */


package org.graalvm.compiler.jtt.reflect;

import java.lang.reflect.Array;

import org.junit.Test;

import org.graalvm.compiler.jtt.JTTTest;

public class Array_set01 extends JTTTest {

    private static final String[] array = {"x", "x", "x"};

    public static String test(int i, String value) {
        Array.set(array, i, value);
        return array[i];
    }

    @Test
    public void run0() throws Throwable {
        runTest("test", 0, "1");
    }

    @Test
    public void run1() throws Throwable {
        runTest("test", 1, "2");
    }

    @Test
    public void run2() throws Throwable {
        runTest("test", 0, "XXd");
    }

    @Test
    public void run3() throws Throwable {
        runTest("test", 3, "--");
    }

}
