/*
 * Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Provides DOM specific transformation classes.
 * <p>
 * The {@link javax.xml.transform.dom.DOMSource} class allows the
 * client of the implementation of this API to specify a DOM
 * {@link org.w3c.dom.Node} as the source of the input tree. The model of
 * how the Transformer deals with the DOM tree in terms of mismatches with the
 * <A href="http://www.w3.org/TR/xslt#data-model">XSLT data model</A> or
 * other data models is beyond the scope of this document. Any of the nodes
 * derived from {@link org.w3c.dom.Node} are legal input.
 * <p>
 * The {@link javax.xml.transform.dom.DOMResult} class allows
 * a {@link org.w3c.dom.Node} to be specified to which result DOM nodes will
 * be appended. If an output node is not specified, the transformer will use
 * {@link javax.xml.parsers.DocumentBuilder#newDocument} to create an
 * output {@link org.w3c.dom.Document} node. If a node is specified, it
 * should be one of the following: {@link org.w3c.dom.Document},
 * {@link org.w3c.dom.Element}, or
 * {@link org.w3c.dom.DocumentFragment}. Specification of any other node
 * type is implementation dependent and undefined by this API. If the result is a
 * {@link org.w3c.dom.Document}, the output of the transformation must have
 * a single element root to set as the document element.
 * <p>
 * The {@link javax.xml.transform.dom.DOMLocator} node may be passed
 * to {@link javax.xml.transform.TransformerException} objects, and
 * retrieved by trying to cast the result of the
 * {@link javax.xml.transform.TransformerException#getLocator()} method.
 * The implementation has no responsibility to use a DOMLocator instead of a
 * {@link javax.xml.transform.SourceLocator} (though line numbers and the
 * like do not make much sense for a DOM), so the result of getLocator must always
 * be tested with an instanceof.
 *
 * @since 1.5
 */

package javax.xml.transform.dom;
